/*==============================================================================
IC - US - GDP, industry structure

Outline:
This do file brings in state level data on
I. 	Employment by Industry, 1970
II. Nominal GDP, 1970


Source of data used in this dofile: 
BEA Regional Economic Accounts
Downloaded from: http://www.bea.gov/regional/downloadzip.cfm
	
Yearbooks use NACE 70. See 1972: Regional statistics (1975), p. 48, for 
industry breakdowns used in yearbooks

For NACE 70 correspondance with modern NACE, see 
http://datalib.chass.utoronto.ca/other/E0032_en.pdf, pp. 177-183

==============================================================================*/

clear all
set more off

*===============================================================================
*I. Employment by Industry, 1970
*===============================================================================

#delim ;
local states 
"AL
AK
AZ
AR
CA
CO
CT
DC
DE
FL
GA
HI
ID
IL
IN
IA
KS
KY
LA
ME
MD
MA
MI
MN
MS
MO
MT
NE
NV
NH
NJ
NM
NY
NC
ND
OH
OK
OR
PA
RI
SC
SD
TN
TX
UT
VT
VA
WA
WV
WI
WY" ; 
#delim cr

*Employment, by Industry
cd "$insheet_files/USA/bea_regional/spi"

foreach state of local states { 

	clear
	quietly insheet using SA25_1969_2001_`state'.csv
	
	quietly keep statefips linecode v9 //keep 1970 data only
	quietly destring statefips, replace force 
		quietly drop if statefips==. //drops footnotes
	quietly destring linecode, replace force
	quietly destring v9, replace force
	
	rename v9 ind
	quietly reshape wide ind, i(statefip) j(linecode)
	
	egen ind_agro = rsum(ind70 ind100) 

	egen ind_energy = rsum(ind220 ind230 ind474 ind570)
	egen ind_mining = rsum(ind210 ind240 ind471)
	gen ind_construction = ind300
	egen ind_metals = rsum(ind423-ind441 ind447)
	egen ind_other = rsum(ind413-ind420 ind444 ind453-ind468 ind477-ind480)
	egen ind_total = rsum(ind_energy-ind_other) 
	
	gen ind_mnfg = ind_metals+ind_other

	egen serv_commerce = rsum(ind610 ind620 ind805 ind825 ind830)
	egen serv_transport = rsum(ind510 ind520 ind530 ind540 ind560)
	egen serv_credit = rsum(ind700 ind820)
	gen serv_admin = ind900
	egen serv_other = rsum(ind810 ind815 ind835-ind880)
	egen serv_total = rsum(serv_commerce-serv_other)

	quietly keep statefip ind_agro-serv_total
	rename statefips statefip
	
	tempfile Ind_EMP`state'
	quietly save `Ind_EMP`state'.dta'
}	

foreach state of local states { 

	quietly append using `Ind_EMP`state'.dta'
}

duplicates drop

sort statefip
tempfile bea_emp_by_ind_1970
save `bea_emp_by_ind_1970.dta'

*===============================================================================
*II. Nominal GDP, 1970
*===============================================================================
cd "$insheet_files/USA/bea_regional"

insheet using gsp_sic_all_C.csv, clear
keep if industryid==1 //all industries
keep if fips>0 & fips<=56

forvalues x=8/42 {
	local year = 1955+`x'
	quietly rename v`x' v`year'
}

keep fips v1970

rename v gdp
	quietly destring gdp, replace 
rename fips statefip

sort statefip
merge 1:1 statefip using  `bea_emp_by_ind_1970.dta', assert(3)
drop _merge

*===============================================================================
* Create observation for US at country level, gen U.S. NUTS equivalent = States 
*===============================================================================
drop if statefip==43 //drop Puerto Rico

gen region=. 
replace region=	840004 if statefip == 1
replace region=	840009 if statefip == 2
replace region=	840008 if statefip == 4
replace region=	840005 if statefip == 5
replace region=	840010 if statefip == 6
replace region=	840008 if statefip == 8
replace region=	840001 if statefip == 9
replace region=	840003 if statefip == 10
replace region=	840003 if statefip == 11
replace region=	840003 if statefip == 12
replace region=	840003 if statefip == 13
replace region=	840003 if statefip == 14
replace region=	840009 if statefip == 15
replace region=	840008 if statefip == 16
replace region=	840006 if statefip == 17
replace region=	840006 if statefip == 18
replace region=	840007 if statefip == 19
replace region=	840007 if statefip == 20
replace region=	840004 if statefip == 21
replace region=	840005 if statefip == 22
replace region=	840001 if statefip == 23
replace region=	840003 if statefip == 24
replace region=	840001 if statefip == 25
replace region=	840006 if statefip == 26
replace region=	840007 if statefip == 27
replace region=	840004 if statefip == 28
replace region=	840007 if statefip == 29
replace region=	840008 if statefip == 30
replace region=	840007 if statefip == 31
replace region=	840008 if statefip == 32
replace region=	840001 if statefip == 33
replace region=	840002 if statefip == 34
replace region=	840008 if statefip == 35
replace region=	840002 if statefip == 36
replace region=	840003 if statefip == 37
replace region=	840007 if statefip == 38
replace region=	840006 if statefip == 39
replace region=	840005 if statefip == 40
replace region=	840009 if statefip == 41
replace region=	840002 if statefip == 42
replace region=	840001 if statefip == 44
replace region=	840003 if statefip == 45
replace region=	840007 if statefip == 46
replace region=	840004 if statefip == 47
replace region=	840005 if statefip == 48
replace region=	840008 if statefip == 49
replace region=	840001 if statefip == 50
replace region=	840003 if statefip == 51
replace region=	840009 if statefip == 53
replace region=	840003 if statefip == 54
replace region=	840006 if statefip == 55
replace region=	840008 if statefip == 56

tempfile US_states
save `US_states.dta'

*Entire U.S.

collapse (sum) gdp ind_* serv_*
gen region= 0 

tempfile entire_US
save	`entire_US.dta'
 
*By Region

use `US_states.dta', clear
collapse (sum) gdp ind_* serv_* , by(region)

append using `US_states.dta'
append using `entire_US.dta'

gen nuts=statefip
	replace nuts= region if statefip==.

tostring nuts, replace force
replace nuts = "US: AK" if nuts=="2" 
replace nuts = "US: AL" if nuts=="1" 
replace nuts = "US: AR" if nuts=="5" 
replace nuts = "US: AS" if nuts=="60" 
replace nuts = "US: AZ" if nuts=="4" 
replace nuts = "US: CA" if nuts=="6" 
replace nuts = "US: CO" if nuts=="8" 
replace nuts = "US: CT" if nuts=="9" 
replace nuts = "US: DC" if nuts=="11" 
replace nuts = "US: DE" if nuts=="10" 
replace nuts = "US: FL" if nuts=="12" 
replace nuts = "US: GA" if nuts=="13" 
replace nuts = "US: GU" if nuts=="66" 
replace nuts = "US: HI" if nuts=="15" 
replace nuts = "US: IA" if nuts=="19" 
replace nuts = "US: ID" if nuts=="16" 
replace nuts = "US: IL" if nuts=="17" 
replace nuts = "US: IN" if nuts=="18" 
replace nuts = "US: KS" if nuts=="20" 
replace nuts = "US: KY" if nuts=="21" 
replace nuts = "US: LA" if nuts=="22" 
replace nuts = "US: MA" if nuts=="25" 
replace nuts = "US: MD" if nuts=="24" 
replace nuts = "US: ME" if nuts=="23" 
replace nuts = "US: MI" if nuts=="26" 
replace nuts = "US: MN" if nuts=="27" 
replace nuts = "US: MO" if nuts=="29" 
replace nuts = "US: MS" if nuts=="28" 
replace nuts = "US: MT" if nuts=="30" 
replace nuts = "US: NC" if nuts=="37" 
replace nuts = "US: ND" if nuts=="38" 
replace nuts = "US: NE" if nuts=="31" 
replace nuts = "US: NH" if nuts=="33" 
replace nuts = "US: NJ" if nuts=="34" 
replace nuts = "US: NM" if nuts=="35" 
replace nuts = "US: NV" if nuts=="32" 
replace nuts = "US: NY" if nuts=="36" 
replace nuts = "US: OH" if nuts=="39" 
replace nuts = "US: OK" if nuts=="40" 
replace nuts = "US: OR" if nuts=="41" 
replace nuts = "US: PA" if nuts=="42" 
replace nuts = "US: PR" if nuts=="72" 
replace nuts = "US: RI" if nuts=="44" 
replace nuts = "US: SC" if nuts=="45" 
replace nuts = "US: SD" if nuts=="46" 
replace nuts = "US: TN" if nuts=="47" 
replace nuts = "US: TX" if nuts=="48" 
replace nuts = "US: UT" if nuts=="49" 
replace nuts = "US: VA" if nuts=="51" 
replace nuts = "US: VI" if nuts=="78" 
replace nuts = "US: VT" if nuts=="50" 
replace nuts = "US: WA" if nuts=="53" 
replace nuts = "US: WI" if nuts=="55" 
replace nuts = "US: WV" if nuts=="54" 
replace nuts = "US: WY" if nuts=="56" 
replace nuts = "Entire U.S." if region==0
replace nuts = "US: New England" if region== 840001 & statefip==.
replace nuts = "US: Middle Atlantic States" if region==840002  & statefip==.
replace nuts = "US: South Atlantic" if region==840003 & statefip==.
replace nuts = "US: East South Central" if region==840004  & statefip==.	
replace nuts = "US: West South Central" if region==840005  & statefip==.	
replace nuts = "US: East North Central" if region==840006  & statefip==.	
replace nuts = "US: West North Central" if region==840007  & statefip==.	
replace nuts = "US: Rocky Mountain state" if region==840008  & statefip==.	
replace nuts = "US: Northwest" if region==840009  & statefip==.
replace nuts = "US: California" if region==840010  & statefip==.

********************************************************************************

save "$dta_files/IC_US_IND_GDP", replace
